/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.world;

import com.alcatrazescapee.alcatrazcore.util.CoreHelpers;
import com.alcatrazescapee.notreepunching.ModConfig;
import com.alcatrazescapee.notreepunching.common.blocks.BlockRock;
import com.alcatrazescapee.notreepunching.util.types.Stone;
import com.google.common.collect.Sets;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenRocks
implements IWorldGenerator {
    private static final Set<Material> MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.field_151578_c, Material.field_151595_p, Material.field_151577_b, Material.field_151571_B, Material.field_151572_C, Material.field_151597_y});

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w != null && world.field_73011_w.getDimension() == 0 && ModConfig.GENERAL.looseRocksGeneration) {
            for (int i = 0; i < ModConfig.GENERAL.looseRocksFrequency; ++i) {
                int xCoord = chunkX * 16 + random.nextInt(16) + 8;
                int zCoord = chunkZ * 16 + random.nextInt(16) + 8;
                if (!((double)random.nextFloat() < 0.5)) continue;
                this.placeRock(world, CoreHelpers.getTopSolidBlock((World)world, (BlockPos)new BlockPos(xCoord, 0, zCoord)), random);
            }
        }
    }

    private void placeRock(World world, BlockPos pos, Random random) {
        IBlockState stateDown;
        IBlockState state = world.func_180495_p(pos.func_177984_a());
        if (!state.func_185904_a().func_76224_d() && !state.func_185914_p() && state.func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177984_a()) && (stateDown = world.func_180495_p(pos)).func_185914_p() && MATERIALS.contains(stateDown.func_185904_a())) {
            Stone stone = Stone.getFromBlock(world.func_180495_p(pos.func_177979_c(6)), random);
            BlockRock stoneBlock = stone.isEnabled() ? BlockRock.get(stone) : BlockRock.get(Stone.STONE);
            world.func_175656_a(pos.func_177984_a(), stoneBlock.func_176223_P());
        }
    }
}

